﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using GTA;

// http://shemesh.wordpress.com/2010/01/22/c-dictionary-get-key-from-value/
namespace Utils
{
    public static class IDictionaryExtensions
    {
        public static TKey FindKeyByValue<TKey, TValue>(this IDictionary<TKey, TValue> dictionary, TValue value)
        {
            if (dictionary == null)
                throw new ArgumentNullException("dictionary");

            foreach (KeyValuePair<TKey, TValue> pair in dictionary)
                if (value.Equals(pair.Value)) return pair.Key;

            throw new Exception("the value is not found in the dictionary");
        }
    }
}
